/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.conndata.LparInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RssfBean
extends PanelBean
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "JRCSRSBT";
    private static final String TRACE_MASKF = "JRCSRSBF";
    private static final String TRACE_MASKD = "JRCSRSBD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -124, "RCS-RssfBean");
    private CecInfo consoleInfo;
    private List managedSystems;
    private String[] m_sConnectionTypeSelection;
    private String m_sPppAddress;
    private boolean m_bAllowConsole;
    private boolean m_bAllowPartition;
    private String m_sManagedSystem;
    private transient ValueDescriptor[] m_vdManagedSystem;
    private transient ItemDescriptor[][] m_idPartitionsTable;
    private transient ColumnDescriptor[] m_cdPartitionsTableStructure;
    private int[] m_iPartitionsTableSelection;

    public RssfBean() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> RssfBean()");
    }

    public void setConnectionTypeSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray.length >= 1) {
            Trace.trace((String)TRACE_MASKF, (Object)("<> setConnectionTypeSelection(" + stringArray[0] + ")"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"<> setConnectionTypeSelection(none)");
        }
        this.m_sConnectionTypeSelection = stringArray;
    }

    public String[] getConnectionTypeSelection() {
        return this.m_sConnectionTypeSelection;
    }

    public void setPppAddress(String string) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("<> setPppAddress(" + string + ")"));
        this.m_sPppAddress = string.toUpperCase();
    }

    public String getPppAddress() {
        return this.m_sPppAddress;
    }

    public void setAllowConsole(boolean bl) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("-> setAllowConsole(" + bl + ")"));
        this.m_bAllowConsole = bl;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKF, (Object)"<- setAllowConsole()");
    }

    public boolean isAllowConsole() {
        return this.m_bAllowConsole;
    }

    public void setAllowPartition(boolean bl) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("-> setAllowPartition(" + bl + ")"));
        this.m_bAllowPartition = bl;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKF, (Object)"<- setAllowPartition()");
    }

    public boolean isAllowPartition() {
        return this.m_bAllowPartition;
    }

    public ValueDescriptor[] getManagedSystemList() {
        return this.m_vdManagedSystem;
    }

    public void setManagedSystem(String string) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKF, (Object)("-> setManagedSystem(" + string + ")"));
        this.m_sManagedSystem = string;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKF, (Object)"<- setManagedSystem()");
    }

    public String getManagedSystem() {
        return this.m_sManagedSystem;
    }

    public void setPartitionsTableSelection(int[] nArray) throws IllegalUserDataException {
        if (nArray != null && nArray.length > 0) {
            Trace.trace((String)TRACE_MASKF, (Object)("-> setPartitionsTableSelection(" + nArray.length + ")"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-> setPartitionsTableSelection(none)");
        }
        this.m_iPartitionsTableSelection = nArray;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKF, (Object)"<- setPartitionsTableSelection()");
    }

    public int[] getPartitionsTableSelection() {
        return this.m_iPartitionsTableSelection;
    }

    public void setPartitionsTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idPartitionsTable[n] = itemDescriptorArray;
    }

    public ItemDescriptor[] getPartitionsTableRowAt(int n) {
        return this.m_idPartitionsTable[n];
    }

    public int getPartitionsTableRowCount() {
        return this.m_idPartitionsTable.length;
    }

    public int getPartitionsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getPartitionsTableRowStructure() {
        return this.m_cdPartitionsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> verifyChanges()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- verifyChanges()");
    }

    public void load() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> load()");
        this.m_sConnectionTypeSelection = new String[0];
        this.m_sPppAddress = "";
        this.m_bAllowConsole = false;
        this.m_bAllowPartition = false;
        this.m_sManagedSystem = "";
        this.m_vdManagedSystem = new ValueDescriptor[0];
        this.m_idPartitionsTable = new ItemDescriptor[0][0];
        this.m_cdPartitionsTableStructure = new ColumnDescriptor[0];
        this.m_iPartitionsTableSelection = new int[0];
        Trace.trace((String)TRACE_MASKT, (Object)"<- load()");
    }

    public void save() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> save()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- save()");
    }

    public void setConsoleInfo(CecInfo cecInfo) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConsoleInfo(" + cecInfo + ")"));
        this.consoleInfo = cecInfo;
    }

    public void setManagedSystems(List list) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setManagedSystems(" + list.size() + ")"));
        this.managedSystems = list;
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<- prepare()");
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> panelAction(" + taskActionEvent + ")"));
        try {
            String string = taskActionEvent.getElementName();
            if (string.endsWith("PrepareButton")) {
                this.userTaskManager.storeElement(this.getMountPrefix() + "PppAddress");
                if (!this.isPppAddressValid()) {
                    String string2 = "INVALID_PPP_ADDR";
                    LocalizableText localizableText = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string2 + ".TITLE");
                    MessageText messageText = new MessageText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string2 + ".MSG");
                    CommonMsgApp.showMessageBox((UserTaskManager)this.userTaskManager, (LocalizableText)localizableText, (MessageText)messageText);
                } else if (this.m_iPartitionsTableSelection.length > 5) {
                    String string3 = "MAX_PARTITIONS";
                    LocalizableText localizableText = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string3 + ".TITLE");
                    MessageText messageText = new MessageText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string3 + ".MSG");
                    CommonMsgApp.showMessageBox((UserTaskManager)this.userTaskManager, (LocalizableText)localizableText, (MessageText)messageText);
                } else {
                    PanelTaskletRequest panelTaskletRequest;
                    CecInfo cecInfo = null;
                    if (this.m_bAllowPartition && (panelTaskletRequest = this.getCecInfo(this.m_sManagedSystem)) != null) {
                        List list = panelTaskletRequest.getPartitions();
                        ArrayList arrayList = new ArrayList();
                        for (int i = 0; i < this.m_iPartitionsTableSelection.length; ++i) {
                            arrayList.add(list.get(this.m_iPartitionsTableSelection[i]));
                        }
                        String string4 = panelTaskletRequest.getType();
                        String string5 = panelTaskletRequest.getModel();
                        String string6 = panelTaskletRequest.getSerial();
                        String string7 = panelTaskletRequest.getUserName();
                        cecInfo = new CecInfo(string4, string5, string6, string7, arrayList);
                    }
                    panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setSource((Object)"RssfBean");
                    panelTaskletRequest.setData("Source", (Object)"RssfPanel");
                    panelTaskletRequest.setData("Command", (Object)"OpenSessionPanel");
                    panelTaskletRequest.setData("ConnectionType", (Object)this.m_sConnectionTypeSelection[0]);
                    panelTaskletRequest.setData("PppAddress", (Object)this.m_sPppAddress);
                    panelTaskletRequest.setData("AllowConsole", (Object)new Boolean(this.m_bAllowConsole));
                    panelTaskletRequest.setData("AllowLpar", (Object)new Boolean(this.m_bAllowPartition));
                    panelTaskletRequest.setData("ConsoleInfo", (Object)this.consoleInfo);
                    panelTaskletRequest.setData("CecInfo", (Object)cecInfo);
                    this.postTaskletRequest(panelTaskletRequest);
                }
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown element");
            }
        }
        catch (Exception exception) {
            new AusMicrocodeLog(classLogInfo, 5, exception).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- panelAction()");
    }

    public void parentalAction(TaskActionEvent taskActionEvent, PanelBean panelBean) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> parentalAction(" + taskActionEvent + ")"));
        try {
            String string = taskActionEvent.getActionCommand();
            if (string == null) {
                string = "";
            }
            Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            } else if (!string.endsWith("ParentalCommit")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- parentalAction()");
    }

    public void update(Object object) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> update()");
        try {
            HashMap hashMap = (HashMap)object;
            String string = (String)hashMap.get("Command");
            if (string == null) {
                string = "";
            }
            Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- update()");
    }

    private void updateDataBeanInfo(boolean bl) {
        List list;
        Trace.trace((String)TRACE_MASKT, (Object)("-> updateDataBeanInfo(" + bl + ")"));
        int n = this.managedSystems.size();
        Trace.trace((String)TRACE_MASKF, (Object)("managedSystems=" + n));
        if (bl) {
            this.m_sConnectionTypeSelection = new String[]{this.getMountPrefix() + "Vpn"};
            if (n > 0) {
                this.m_vdManagedSystem = new ValueDescriptor[n];
                for (int i = 0; i < n; ++i) {
                    list = (CecInfo)this.managedSystems.get(i);
                    String string = list.getDisplayName();
                    this.m_vdManagedSystem[i] = new ValueDescriptor(null, string);
                    if (i != 0) continue;
                    this.m_sManagedSystem = string;
                }
            } else {
                this.m_vdManagedSystem = new ValueDescriptor[0];
                this.m_sManagedSystem = "";
            }
        }
        CecInfo cecInfo = this.getCecInfo(this.m_sManagedSystem);
        if (n > 0 && cecInfo != null) {
            list = cecInfo.getPartitions();
            int n2 = list.size();
            Trace.trace((String)TRACE_MASKF, (Object)("partitions=" + n2));
            this.m_idPartitionsTable = new ItemDescriptor[n2][2];
            for (int i = 0; i < n2; ++i) {
                LparInfo lparInfo = (LparInfo)list.get(i);
                String string = lparInfo.getNumber();
                this.m_idPartitionsTable[i][0] = new ItemDescriptor(null, string);
                String string2 = lparInfo.getUserName();
                this.m_idPartitionsTable[i][1] = new ItemDescriptor(null, string2);
            }
        } else {
            this.m_idPartitionsTable = new ItemDescriptor[0][0];
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            if (this.m_bAllowPartition) {
                this.userTaskManager.setEnabled(string + "ManagedSystem", true);
                this.userTaskManager.setEnabled(string + "PartitionsTable", true);
            } else {
                this.userTaskManager.setEnabled(string + "ManagedSystem", false);
                this.userTaskManager.setEnabled(string + "PartitionsTable", false);
            }
            if (this.m_bAllowConsole || this.m_bAllowPartition && this.m_iPartitionsTableSelection.length > 0) {
                this.userTaskManager.setEnabled(string + "PrepareButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "PrepareButton", false);
            }
            this.userTaskManager.refreshElement(string + "ManagedSystem");
            this.userTaskManager.refreshElement(string + "PartitionsTable");
            this.userTaskManager.refreshElement(string + "PrepareButton");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateUTMElements()");
    }

    private CecInfo getCecInfo(String string) {
        CecInfo cecInfo = null;
        Iterator iterator = this.managedSystems.iterator();
        while (iterator.hasNext()) {
            CecInfo cecInfo2 = (CecInfo)iterator.next();
            if (!cecInfo2.getDisplayName().equals(string)) continue;
            cecInfo = cecInfo2;
            break;
        }
        return cecInfo;
    }

    private boolean isPppAddressValid() {
        Trace.trace((String)TRACE_MASKF, (Object)("m_sConnectionTypeSelection=" + this.m_sConnectionTypeSelection[0]));
        Trace.trace((String)TRACE_MASKF, (Object)("m_sPppAddress=" + this.m_sPppAddress));
        if (this.m_sConnectionTypeSelection.length >= 1 && !this.m_sConnectionTypeSelection[0].endsWith("PppAddress")) {
            return true;
        }
        if (this.m_sPppAddress == null || this.m_sPppAddress.equals("")) {
            return false;
        }
        if (this.m_sPppAddress.length() != 2) {
            return false;
        }
        for (int i = 0; i < this.m_sPppAddress.length(); ++i) {
            char c = this.m_sPppAddress.charAt(i);
            if ("0123456789ABCDEF".indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }
}

